## -*-Tcl-*-
 # ###################################################################
 #  HTML mode - tools for editing HTML documents
 # 
 #  FILE: "htmlMenu.tcl"
 #                                    created: 96-04-29 21.31.40 
 #                                last update: 99-04-24 13.17.44 
 #  Author: Johan Linde
 #  E-mail: <jlinde@telia.com>
 #     www: <http://www.theophys.kth.se/~jl/Alpha.html>
 #  
 # Version: 2.1.4
 # 
 # Copyright 1996-1999 by Johan Linde
 #  
 # This software may be used freely, and distributed freely, as long as the 
 # receiver is not obligated in any way by receiving it.
 #  
 # If you make improvements to this file, please share them!
 # 
 # ###################################################################
 ##

proc htmlMenu.tcl {} {}

proc htmlMarkExtUtil {} {
	global htmlUtilsMenu htmlElemKeyBinding htmlAdditionExist htmlShownWarning
	enableMenuItem $htmlUtilsMenu Extend [expr ![info exists htmlShownWarning]]
	htmlEnableExtend [info exists htmlElemKeyBinding] $htmlAdditionExist
}

proc htmlHide {} {
	htmlDisableSome on
	htmlSetDis
	htmlDisableSome off
}

# Disable some HTML elements	
proc htmlDisableSome {onoff} {
	global htmlElemKeyBinding htmlDisabledItems htmlMenu
	foreach i $htmlDisabledItems {
		set it [split $i /]
		enableMenuItem [lindex $it 0] [lindex $it 1] $onoff
	}
}

proc htmlUseBigBrother {} {
	global HTMLmodeVars modifiedModeVars
	set HTMLmodeVars(useBigBrother) [expr !$HTMLmodeVars(useBigBrother)]
	if {[catch {nameFromAppl Bbth}]} {
		set HTMLmodeVars(useBigBrother) 0
		enableMenuItem {Check Links} {Use Big Brother} off
	}
	markMenuItem -m {Check Links} {Use Big Brother} $HTMLmodeVars(useBigBrother) 
	lappend modifiedModeVars {useBigBrother HTMLmodeVars}
	message "[lindex {"Don't use" Use} [set HTMLmodeVars(useBigBrother)]] Big Brother."
}

# Called from HTML menu to change browser.
proc htmlToggleBrowser {brws} {
	global htmlBrowsers browserSig modifiedVars
	foreach b $htmlBrowsers {
		if {$brws == [lindex $b 1]} {set browserSig [lindex $b 0]}
	}
	lappend modifiedVars browserSig
	if {![key::optionPressed]} {htmlSendWindow}
}

# Called whenever browserSig is changed.
proc htmlToggleBrowser2 {args} {
	global browserSig htmlBrowsers HTMLmodeVars
	if {[lsearch -exact $HTMLmodeVars(browsers) $browserSig] < 0} {htmlAddBrowser $browserSig}
	foreach b $htmlBrowsers {
		if {$browserSig == [lindex $b 0]} {
			markMenuItem -m Browsers [lindex $b 1] on 
		} else {
			markMenuItem -m Browsers [lindex $b 1] off
		}
	}
}

# Add a browser to Browser menu.
proc htmlAddBrowser {{sig ""}} {
	global htmlBrowsers HTMLmodeVars modifiedModeVars browserSig
	if {$sig == ""} {
		set fil [getfile "Locate a web browser."]
		set sig [getFileSig $fil]
	}
	if {[catch {nameFromAppl $sig} fil]} {
		alertnote "Couldn't get the name of the browser. If nothing else helps try rebuilding the desktop."
		return
	}
	if {[lsearch -exact $HTMLmodeVars(browsers) $sig] >= 0} {return}
	lappend HTMLmodeVars(browsers) $sig
	lappend modifiedModeVars {browsers HTMLmodeVars}
	lappend htmlBrowsers [list $sig [set app [file tail $fil]]]
	htmlAddBrowserItem $app $sig
	if {$sig == $browserSig} {markMenuItem -m "Browsers" $app on }
	message "$app added to Browsers menu."
}

# Remove a browser from Browser menu.
proc htmlRemoveBrowser {} {
	global htmlBrowsers HTMLmodeVars modifiedModeVars browserSig modifiedVars
	foreach b $htmlBrowsers {
		lappend tmp [lindex $b 1]
	}
	if {[catch {listpick -p "Select browser to remove" $tmp} brws] || $brws == ""} {return}
	for {set i 0} {$i < [llength $htmlBrowsers]} {incr i} {
		if {$brws == [lindex [lindex $htmlBrowsers $i] 1]} {
			deleteMenuItem -m Browsers $brws
			if {[lindex $HTMLmodeVars(browsers) $i] == $browserSig} {
				set j 0
				if {$i == 0} {incr j}
				if {$j < [llength $HTMLmodeVars(browsers)]} {set browserSig [lindex $HTMLmodeVars(browsers) $j]}
				lappend modifiedVars browserSig
			}
			set htmlBrowsers [lreplace $htmlBrowsers $i $i]
			set HTMLmodeVars(browsers) [lreplace $HTMLmodeVars(browsers) $i $i] 
		}
	}
	lappend modifiedModeVars {browsers HTMLmodeVars}
	message "$brws removed from Browsers menu."
}

proc htmlAddBrowserItem {app sig} {
	global alpha::version
	switch $sig {
		MOSS {
			if {[string match "*Navigator*" $app]} {
				set ic 85
			} else {
				set ic 86
			}
		}
		MSIE {set ic 87}
		OlG1 {set ic 88}
		dogz {set ic 73}
		iCAB {
			if {[alpha::package vsatisfies ${alpha::version} 7.2fc11]} {
				set ic 89
			} else {
				set ic 78
			}
		}
		default {set ic 78}
	}
	addMenuItem -m Browsers [menu::itemWithIcon $app $ic]
}

proc htmlEnableURLs {onoff} {
	enableMenuItem URLs "Clean Up" $onoff
	enableMenuItem URLs "Clear" $onoff
	enableMenuItem URLs "Export" $onoff
}

proc htmlEnablewindows {onoff} {
	global htmlUtilsMenu
	enableMenuItem $htmlUtilsMenu Windows $onoff
}

proc htmlEnableExtend {a b} {
	enableMenuItem Extend "Change Key Binding" $a
	enableMenuItem Extend "Change Type and Layout" $a
	enableMenuItem Extend "Remove Attributes" $b
	enableMenuItem Extend "Remove Additions" $b
}

proc htmlActivateHook {args} {
	global htmlHideDeprecated htmlHideExtensions htmlHideFrames
	set htmlHideExtensions 0
	set htmlHideDeprecated 0
	set htmlHideFrames 0
	set doc [htmlFindDoctype]
	if {$doc == "transitional" || $doc == "frameset"} {
		set htmlHideExtensions 1
		if {$doc == "transitional"} {set htmlHideFrames 1}
	} elseif {$doc == "strict"} {
		set htmlHideDeprecated 1
	}
	htmlHide
}

proc htmlFindDoctype {} {
	if {![catch {search -s -f 1 -r 1 -i 1 -m 0 {<!doctype[^<>]+html[ \t\r\n]+4.0[ \t\r\n]+transitional[^<>]+>} 0}]} {
		return transitional
	} elseif {![catch {search -s -f 1 -r 1 -i 1 -m 0 {<!doctype[^<>]+html[ \t\r\n]+4.0[ \t\r\n]+frameset[^<>]+>} 0}]} {
		return frameset
	} elseif {![catch {search -s -f 1 -r 1 -i 1 -m 0 {<!doctype[^<>]+html[ \t\r\n]+4.0[ \t\r\n]*//[^<>]+>} 0}]} {
		return strict
	}
	return ""
}

#===============================================================================
# Menu Processing
#===============================================================================

proc htmlMenuItem {menu item} {
	global htmlElemProc htmlDisabledItems
	global screenWidth defWidth

	foreach it $htmlDisabledItems {
		if {[lindex [split $it /] 1] == $menu || "${menu}/$item" == $it} {beep; return}
	}
	
	switch -glob $menu {
		"*" {eval html[join $item ""]}
		"Browsers" {
			switch $item {
				"Send File to Browser"	{htmlSendWindow}
				"Add"	{htmlAddBrowser}
				"Remove" {htmlRemoveBrowser}
				default {htmlToggleBrowser $item}
			}
		}
		"Preferences" {HTMLmodifyFlags [lindex $item 0]}
		"Palettes" {float -m "$item" -t 50 -l [expr $screenWidth - $defWidth > 110 ? $defWidth : $screenWidth - 110] -z HTML} 
		"Editing" {eval html[join $item ""]}
		"Validate" {eval html[join $item ""]}
		"Character Translation"	{
			switch $item {
				" -> HTML"		{htmlCharacterstohtml 0}
				"HTML -> "	{htmltoCharacters 0}
				"<>& -> HTML"	{htmlCharacterstohtml 1}
				"HTML -> <>&"	{htmltoCharacters 1}
				default {eval html[join $item ""]}
			}
		}
		"URLs"	{
			switch $item {
				"Clean Up"		{htmlCleanUpCache URLs}
				"Clear"			{htmlClearCache URLs}
				default {eval html[join $item ""]}
			}
		}
		"Windows"	{
			switch $item {
				"Clean Up"	{htmlCleanUpCache windows}
				"Clear"		{htmlClearCache windows}
				default {eval html[join $item ""]}
			}
		}
		"Check Links" {eval html[join $item ""]}
		"Includes" {eval html[join $item ""]}
		"Home Page Windows" {
			switch $item {
				"Open" {htmlOpenHPwin}
				default {eval html[join $item ""]}
			}
		}
		"Extend" {eval html[join $item ""]}
		"Style Sheets" {
			switch $item {
				Style {htmlTag {htmlBuildCR2Elem STYLE}}
				Span {htmlTag {htmlBuildElem SPAN}}
				Import {cssDialog @import}
				Display {cssDialog Display}
				default {
					if {[info commands html[join $item ""]] != ""} {
						eval html[join $item ""]
					} else {
						cssDialog [join [string tolower $item] -]}
					}
			}
		}
		"Headers" {
			switch $item {
				"Header1"	{htmlTag {htmlBuildCRElem H1 1}}
				"H1 no attr" {htmlTag {htmlBuildCRElem H1 1 NOATTR}}
				"Header2"	{htmlTag {htmlBuildCRElem H2 1}}
				"H2 no attr" {htmlTag {htmlBuildCRElem H2 1 NOATTR}}
				"Header3"	{htmlTag {htmlBuildCRElem H3 1}}
				"H3 no attr" {htmlTag {htmlBuildCRElem H3 1 NOATTR}}
				"Header4"	{htmlTag {htmlBuildCRElem H4 1}}
				"H4 no attr" {htmlTag {htmlBuildCRElem H4 1 NOATTR}}
				"Header5"	{htmlTag {htmlBuildCRElem H5 1}}
				"H5 no attr" {htmlTag {htmlBuildCRElem H5 1 NOATTR}}
				"Header6"	{htmlTag {htmlBuildCRElem H6 1}}
				"H6 no attr" {htmlTag {htmlBuildCRElem H6 1 NOATTR}}
				default {eval html[join $item ""]}
			}
		}
		"Blocks and Dividers" {
			switch $item {
				"Paragraph"	{htmlElemParagraph}
				"P no attr" {htmlElemParagraph NOATTR}
				"Division"		{htmlTag {htmlBuildCR2Elem DIV}}
				"Block Quote"	{htmlTag {htmlBuildCR2Elem BLOCKQUOTE}}
				"Address"		{htmlTag {htmlBuildCRElem ADDRESS}}
				"Center"		{htmlTag {htmlBuildCR2Elem CENTER}}
				"Preformatted"	{htmlTag {htmlBuildCR2Elem PRE}}
				"Multi Column"	{htmlTag {htmlBuildCR2Elem MULTICOL}}
				"Spacing"		{htmlTag {htmlBuildOpening SPACER}}
				"Direction Override" {htmlTag {htmlBuildCRElem BDO}}
				"Inserted Text"	{htmlTag {htmlBuildCRElem INS}}
				"Deleted Text"	{htmlTag {htmlBuildCRElem DEL}}
				"Line Break"		{htmlTag {htmlBuildOpening BR 0 1}}
				"BR no attr"		{htmlTag {htmlBuildOpening BR 0 1 NOATTR}}
				"Horizontal Rule"	{htmlTag {htmlBuildOpening HR 1 1}}
				"HR no attr"	{htmlTag {htmlBuildOpening HR 1 1 NOATTR}}
				"No Line Break"	{htmlTag {htmlBuildElem NOBR}}
				"Word Break"	{htmlTag {htmlBuildOpening WBR 0 1}}
				default {eval html[join $item ""]}
			}
		}
		"Styles"	{
			switch $item {
				"Font"			{htmlTag {htmlBuildElem FONT}}
				"Basefont"		{htmlTag {htmlBuildOpening BASEFONT 1 1}}
				"Marquee"		{htmlTag {htmlBuildCRElem MARQUEE}}
				"Bold"			{htmlTag {htmlBuildElem B}}
				"Italic"		{htmlTag {htmlBuildElem I}}
				"Strike out"	{htmlTag {htmlBuildElem STRIKE}}
				"Underlined"	{htmlTag {htmlBuildElem U}}
				"Subscript"		{htmlTag {htmlBuildElem SUB}}
				"Superscript"	{htmlTag {htmlBuildElem SUP}}
				"Bigger"		{htmlTag {htmlBuildElem BIG}}
				"Smaller"		{htmlTag {htmlBuildElem SMALL}}
				"Emphasis"		{htmlTag {htmlBuildElem EM}}
				"Strong"		{htmlTag {htmlBuildElem STRONG}}
				"Definition"	{htmlTag {htmlBuildElem DFN}}
				"Code"			{htmlTag {htmlBuildElem CODE}}
				"Variable"		{htmlTag {htmlBuildElem VAR}}
				"Citation"		{htmlTag {htmlBuildElem CITE}}
				"Keyboard"		{htmlTag {htmlBuildElem KBD}}
				"Typewriter"	{htmlTag {htmlBuildElem TT}}
				"Sample"		{htmlTag {htmlBuildElem SAMP}}
				"Blinking"		{htmlTag {htmlBuildElem BLINK}}
				"Quotation"		{htmlTag {htmlBuildElem Q}}
				"Abbreviation"	{htmlTag {htmlBuildElem ABBR}}
				"Acronym"		{htmlTag {htmlBuildElem ACRONYM}}
				default {eval html[join $item ""]}
			}
		}
		"Links"	{
			switch $item {
				"Link or Anchor" {htmlTag {htmlBuildElem A}}
				"Image"	{htmlTag {htmlBuildOpening IMG}}
				Object {htmlTag {htmlBuildCR2Elem OBJECT}}
				Sound {htmlTag {htmlBuildOpening BGSOUND 1 1}}
				default {eval html[join $item ""]}
			}
		}
		"Plug-ins" {
			switch $item {
				"General" {htmlTag {htmlBuildOpening EMBED}}
				"LiveAudio" {htmlTag {htmlBuildOpening EMBED 0 0 LIVEAUDIO}}
				"LiveVideo" {htmlTag {htmlBuildOpening EMBED 0 0 LIVEVIDEO}}
				"QuickTime Movie" {htmlTag {htmlBuildOpening EMBED 0 0 "QUICKTIME MOVIE"}}
				"QuickTime VR" {htmlTag {htmlBuildOpening EMBED 0 0 "QUICKTIME VR"}}
				"RealAudio"	{htmlTag {htmlBuildOpening EMBED 0 0 REALAUDIO}}
				"No Embed" {htmlTag {htmlBuildCR2Elem NOEMBED}}
				default {eval html[join $item ""]}
			}
		}
		"Lists"	{
			switch $item {
				"Bulleted"	{htmlTag {htmlBuildList UL "LI IN UL" UL}}
				"UL no attr"	{htmlTag {htmlBuildList UL NOATTR NOATTR}}
				"New Bulleted Item" {htmlTag {htmlBuildListEntry "LI IN UL"}}
				"Numbered"	{htmlTag {htmlBuildList OL "LI IN OL" OL}}
				"OL no attr"	{htmlTag {htmlBuildList OL NOATTR NOATTR}}
				"New Numbered Item" {htmlTag {htmlBuildListEntry "LI IN OL"}}
				"Directory"	{htmlTag {htmlBuildList DIR LI}}
				"Menu"		{htmlTag {htmlBuildList MENU LI}}
				"New List Item"	{htmlTag {htmlBuildListEntry LI}}
				"Discursive"	{htmlTag {htmlBuildList DL}}
				default {eval html[join $item ""]}
			}
		}
		"Forms" {
			switch $item {
				"Form"		{htmlTag {htmlBuildCR2Elem FORM}}
				"Field Set" {htmlTag {htmlBuildCR2Elem FIELDSET}}
				"Legend"	{htmlTag {htmlBuildCRElem LEGEND}}
				"Label"		{htmlTag {htmlBuildElem LABEL}}
				"Text"		{htmlTag {htmlBuildInputElem TEXT}}
				"Checkbox"	{htmlTag {htmlBuildInputElem CHECKBOX}}
				"Input Button"	{htmlTag {htmlBuildInputElem BUTTON}}
				"Radio"		{htmlTag {htmlBuildInputElem RADIO}}
				"Submit"		{htmlTag {htmlBuildInputElem SUBMIT}}
				"Reset"		{htmlTag {htmlBuildInputElem RESET}}
				"Password"	{htmlTag {htmlBuildInputElem PASSWORD}}
				"Hidden"		{htmlTag {htmlBuildInputElem HIDDEN}}
				"Image"		{htmlTag {htmlBuildInputElem IMAGE}}
				"File Upload" {htmlTag {htmlBuildInputElem FILE}}
				"Button"	{htmlTag {htmlBuildCRElem BUTTON}}
				"Select"		{htmlTag {htmlBuildCR2Elem SELECT}}
				"Option Group" {htmlTag {htmlBuildCR2Elem OPTGROUP}}
				"Option"		{htmlTag {htmlBuildOpening OPTION 1}}
				"Textarea"	{htmlTag {htmlBuildCRElem TEXTAREA}}
				"Key Generator" {htmlTag {htmlBuildOpening KEYGEN 1 1}}
				default {eval html[join $item ""]}
			}
		}
		"Tables" {
			switch $item {
				Table	{htmlTag {htmlBuildCR2Elem TABLE}}
				Row		{htmlTag {htmlBuildCR2Elem TR}}
				"TR no attr"		{htmlTag {htmlBuildCR2Elem TR NOATTR}}
				Header		{htmlTag {htmlBuildElem TH}}
				"TH no attr"		{htmlTag {htmlBuildElem TH NOATTR}}
				Cell		{htmlTag {htmlBuildElem TD}}
				"TD no attr"		{htmlTag {htmlBuildElem TD NOATTR}}
				Caption	{htmlTag {htmlBuildCRElem CAPTION}}
				Head {htmlTag {htmlBuildOpening THEAD 1 1}}
				Body {htmlTag {htmlBuildOpening TBODY 1 1}}
				Foot {htmlTag {htmlBuildOpening TFOOT 1 1}}
				"Column Group" {htmlTag {htmlBuildOpening COLGROUP 1 1}}
				Column {htmlTag {htmlBuildOpening COL 1 1}}
				default {eval html[join $item ""]}
			}
		}
		"Frames" {
			switch $item {
				Frameset		{htmlTag {htmlBuildCR2Elem FRAMESET}}
				Frame		{htmlTag {htmlBuildOpening FRAME 1 1}}
				"Inline Frame" {htmlTag {htmlBuildElem IFRAME}}
				"No Frames"	{htmlTag {htmlBuildCR2Elem NOFRAMES}}
				default {eval html[join $item ""]}
			}
		}
		"Image Maps" {
			switch $item {
				Map		{htmlTag {htmlBuildCR2Elem MAP}}
				Area	{htmlTag {htmlBuildOpening AREA 1 1}}
				default {eval html[join $item ""]}
			}
		}
		"Java and JavaScript"	{
			switch $item {
				Applet	{htmlTag {htmlBuildCR2Elem APPLET}}
				Parameter {htmlTag {htmlBuildOpening PARAM 1 1}}
				Script	{htmlTag {htmlBuildCR2Elem SCRIPT}}
				"No Script" {htmlTag {htmlBuildCR2Elem NOSCRIPT}}
				Server {htmlTag {htmlBuildCR2Elem SERVER}}
				default {eval html[join $item ""]}
			}
		}
		"Layers" {
			switch $item {
				Layer {htmlTag {htmlBuildCR2Elem LAYER}}
				"Inline Layer" {htmlTag {htmlBuildCRElem ILAYER}}
				"No Layer" {htmlTag {htmlBuildCR2Elem NOLAYER}}
				default {eval html[join $item ""]}
			}
		}
		"Other"	{
			switch $item {
				"Base"	{htmlTag {htmlBuildOpening BASE 1 1}}
				"Isindex" {htmlTag {htmlBuildOpening ISINDEX 1 1}}
				"Link"	{htmlTag {htmlBuildOpening LINK 1 1}}
				"Meta"	{htmlTag {htmlBuildOpening META 1 1}}
				default {eval html[join $item ""]}
			}
		}
		"Character Entities"	{
			switch $item {
				"Add"	{htmlAddCommonChars}
				"Default" {htmlDefaultCommonChars}
				"Clear"	{htmlClearCommonChars}
				default		{htmlInsertCharacter $item}
			}
		}
		"*Chars*" {
			htmlInsertCharacter $item
		}
		"Custom"	{
			htmlTag $htmlElemProc([string toupper $item])
		}
	}
}


# Variables defining the sub menus. More variables in hctsmslMenu.tcl

set htmlHTMLSub {{"<I/t" "Help"} {"<B/m" "Use Attributes"} {"<U<O/N" "New Document"}}

set htmlBrowsersSub {{"<U<O/S" "Send File to Browser"} "(-" {"" "Add"} {"" "Remove"} "(-"}

set htmlPreferencesSub {{"" "General"} {"" "Attributes"} {"" "Indentation"} {"" "JavaScript and CSS"}
	{"" "Checking Links"} {"" "Word Wrapping"}}
	
set htmlUtilitiesSub {{"" "Colors"} {"" "Home Pages"} {"" "Footers"} {"" "Key Bindings"}
	{"<O/I" "Reformat Paragraph/Reformat Document"} {"" "Save to FTP Server/Forget Passwords"} 
	{"" "Move Files"} {"" "Last Modified"} {"" "Document Type"} {"" "Document Size"} 
	{"" "Document Index"}}

set htmlEditingSub {{"<O/B" "Select Container/Select Opening"}
	{"<U<O/B" "Select in Container"}
	{"<B/e" "Untag/Untag and Select"} {"<B/f" "Remove Opening"}
	{"<B/g" "Change Container/Change Opening"} {"<B/h" "Change Choice"}
	{"<B/i" "Reveal Color"} {"<B/j" "Insert Attributes"} {"" "Quote All Attributes"}
	{"" "Tags to Uppercase/Tags to Lowercase"} {"" "Remove Tags"}}

set htmlValidateSub {{"" "Find Unbalanced Tags"} {"" "Check Tags"}}

set htmlCharacterSub {{"" " -> HTML"} {"" "HTML -> "}}

set htmlURLsSub {{"" "Clean Up"} {"" "Clear"} {"" "Import"} {"" "Export"} {"" "Add Folder"}
	{"" "Add Selection"} {"" "Add Clipboard"}}

set htmlWindowsSub {{"" "Clean Up"} {"" "Clear"}}

set htmlCheckSub {{"" "Check Window"} {"" "Check Home Page"} {"" "Check Folder"} {"" "Check File"}
	{"" "Check Remote Links"} "(-" {"" "Use Big Brother"}}

set htmlIncludesSub {{"" "Insert Include Tags"} "(-" {"" "Update Window"} {"" "Update Home Page"}
	{"" "Update Folder"} {"" "Update File"}}

set htmlHomeSub {{"" Open} {"<U<O/V" "Paste URL/Paste Include Tags"} {"" "Refresh Windows"}}

set htmlExtendSub {{"" "New Element"} {"" "New Attributes"} {"" "New Choices"} {"" "Change Key Binding"}
	{"" "Change Type and Layout"} {"" "Remove Attributes"} {"" "Remove Additions"}}

set htmlUtilSubMenus {Utilities Editing Validate {Character Translation} URLs Windows
{Check Links} Includes {Home Page Windows} Extend}

#
# The menu.
#
# <B = control <I = option <U = shift <O = command <S = dynamic

proc htmlBuildMenu {{msg "Building HTML menu"}} {
	global HTMLmodeVars htmlMenu
	
	html40.tcl
	
	if {[catch {htmlReadCache "HTML menu cache"}]} {
		message $msg
		htmlBuildMenu0
	} else {
		message "Reading HTML menu definition"
	}
	insertMenu $htmlMenu

	htmlBrowsersMenuExtra
}

proc htmlBuildMenu0 {} {
	global htmlCustomMenuList modifiedModeVars htmlStartElements
	global htmlMenu HTMLmodeVars htmlSmallCharsMenu
	global htmlCapitalCharsMenu  htmlOtherChars1Menu htmlOtherChars2Menu
	global htmlElemKeyBinding htmlMenuKey
	global htmlSubMenus customHTMLpalettes
	
	set commonChars $HTMLmodeVars(commonChars)
	# Build submenus
	htmlReadMenuKeys
	foreach me $htmlSubMenus {
		set [lindex $me 0]Menu [htmlBuildOneMenu $me]
	}
	
	
	lappend htmlMenuList [list menu -M HTML -p htmlMenuItem -m -n Browsers $BrowsersMenu]
	append htmlMenuList " " [lindex $HTMLMenu 0]
	lappend htmlMenuList [list menu -M HTML -p htmlMenuItem -m -n Preferences $PreferencesMenu]
	# add custom pallettes if any
	if {[info exists customHTMLpalettes]} {
		lappend htmlMenuList [list menu -M HTML -p htmlMenuItem -m -n Palettes $customHTMLpalettes]
	}
	lappend htmlMenuList [lindex $HTMLMenu 1] "(-" [lindex $HTMLMenu 2]
	for {set i $htmlStartElements} {$i < [llength $htmlSubMenus]} {incr i} {
		lappend htmlMenuList [list menu -M HTML -p htmlMenuItem -m -n [lindex $htmlSubMenus $i] [set [lindex [lindex $htmlSubMenus $i] 0]Menu]]
	}
	
	# Allow user to insert custom menu items	
	if {[info exists htmlElemKeyBinding]} {
		foreach elem [lsort [array names htmlElemKeyBinding]] {
			lappend customMenuList "$htmlElemKeyBinding($elem)[string range $elem 0 0][string tolower [string range $elem 1 end]]"
		}
		set htmlCustomMenu [list menu -M HTML -p htmlMenuItem -m -n "Custom" $customMenuList]
		lappend htmlMenuList $htmlCustomMenu
	}
		
	# Character entities
	set htmlSmallCharMenu [list menu -M HTML -p htmlMenuItem -m -n "Small Chars" \
	$htmlSmallCharsMenu]
	set htmlCapCharsMenu [list menu -M HTML -p htmlMenuItem -m -c -n "Capital Chars" \
	$htmlCapitalCharsMenu]
	set htmlSymbCharsMenu1 [list menu -M HTML -p htmlMenuItem -m -n "Other Chars 1" $htmlOtherChars1Menu]
	set htmlSymbCharsMenu2 [list menu -M HTML -p htmlMenuItem -m -n "Other Chars 2" $htmlOtherChars2Menu]
	set tmp $commonChars
	if {[llength $commonChars]} {lappend tmp "(-"}
	lappend tmp Add Default Clear $htmlSmallCharMenu $htmlCapCharsMenu $htmlSymbCharsMenu1 $htmlSymbCharsMenu2
	set htmlCharsMenu [list menu -M HTML -p htmlMenuItem -m -n "Character Entities" $tmp]
	lappend htmlMenuList $htmlCharsMenu
	
	# Define menu
	menu -M HTML -m  -p htmlMenuItem -n $htmlMenu $htmlMenuList
	
	set h {menu -M HTML -m  -p htmlMenuItem -n $htmlMenu}
	lappend h $htmlMenuList
	htmlSaveCache "HTML menu cache" $h
	catch {unset htmlMenuKey}
}


proc htmlRebuildMenu {msg} {
	htmlDeleteCache "HTML menu cache"
	htmlBuildMenu $msg
}

# Add browsers to Browser menu
proc htmlBrowsersMenuExtra {} {
	global HTMLmodeVars browserSig modifiedModeVars htmlBrowsers
	if {[lsearch -exact $HTMLmodeVars(browsers) $browserSig] < 0} {
		lappend HTMLmodeVars(browsers) $browserSig
		lappend modifiedModeVars {browsers HTMLmodeVars}
	}
	set htmlBrowsers {}
	set tmpbrws {}
	foreach brws $HTMLmodeVars(browsers) {
		if {![catch {nameFromAppl $brws} name]} {
			set name [file tail $name]
			lappend htmlBrowsers [list $brws $name]
			lappend tmpbrws $brws
			htmlAddBrowserItem $name $brws
			if {$brws == $browserSig} {markMenuItem -m "Browsers" $name on }
		} else {
			lappend modifiedModeVars {browsers HTMLmodeVars}
		}
	}
	set HTMLmodeVars(browsers) $tmpbrws
}

# Mark and disable some stuff
proc htmlDisMark {} {
	htmlDisableSome off
}

proc htmlBuildUtilsMenu {{msg "Building HTML Utilities menu"}} {
	global htmlUtilsMenu

	if {[catch {htmlReadCache "HTML Utilities menu cache"}]} {
		message $msg
		htmlBuildUtilsMenu0
	} else {
		message "Reading HTML Utilities menu definition"
	}
	insertMenu $htmlUtilsMenu
	
	htmlCharacterMenuExtra
	htmlCheckMenuExtra
	htmlURLsMenuExtra
	htmlWindowsMenuExtra
	htmlUtilDisMark

}

proc htmlRebuildUtilsMenu {msg} {
	htmlDeleteCache "HTML Utilities menu cache"
	htmlBuildUtilsMenu $msg
}

proc htmlBuildUtilsMenu0 {} {
	global htmlUtilSubMenus HTMLmodeVars htmlUtilsMenu htmlMenuKey
	# Build submenus
	htmlReadMenuKeys
	foreach me $htmlUtilSubMenus {
		set [lindex $me 0]Menu [htmlBuildOneMenu $me]
	}

	foreach me [lrange $htmlUtilSubMenus 1 end] {
		lappend utilSubs [list menu -M HTML -p htmlMenuItem -m -n $me [set [lindex $me 0]Menu]]
	}
	
	menu -M HTML -p htmlMenuItem -m \
	-n $htmlUtilsMenu [concat [lrange  $UtilitiesMenu 0 3] "(-" \
	$utilSubs "(-" [lrange $UtilitiesMenu 4 end]]
	
	set h {menu -M HTML -p htmlMenuItem -m -n $htmlUtilsMenu}
	lappend h [concat [lrange  $UtilitiesMenu 0 3] "(-" \
	$utilSubs "(-" [lrange $UtilitiesMenu 4 end]]
	htmlSaveCache "HTML Utilities menu cache" $h
	catch {unset htmlMenuKey}
}

# Add some things to translation menu.
proc htmlCharacterMenuExtra {} {
	addMenuItem -m -l "" "Character Translation" "<>& -> HTML"
	addMenuItem -m -l "" "Character Translation" "HTML -> <>&"
}

# Check if Big Brother exists and if it should be used.
proc htmlCheckMenuExtra {} {
	global HTMLmodeVars modifiedModeVars
	if {[catch {nameFromAppl Bbth}]} {
		enableMenuItem "Check Links" "Use Big Brother" off
		enableMenuItem "Check Links" "Check Remote Links" off
		if {$HTMLmodeVars(useBigBrother)} {
			set HTMLmodeVars(useBigBrother) 0
			lappend modifiedModeVars {useBigBrother HTMLmodeVars}
		}
	} elseif {$HTMLmodeVars(useBigBrother)} {
		markMenuItem -m {Check Links} {Use Big Brother} 1 
	}
}

# Disable URLs menu if cache is empty.
proc htmlURLsMenuExtra {} {
	global HTMLmodeVars
	if {![llength $HTMLmodeVars(URLs)]} {htmlEnableURLs off}
}

# Disable Windows menu if cache is empty.
proc htmlWindowsMenuExtra {} {
	global HTMLmodeVars
	if {![llength $HTMLmodeVars(windows)]} {htmlEnablewindows off}
}

# Mark and disable some stuff
proc htmlUtilDisMark {} {
	htmlMarkExtUtil
}

proc htmlSetDis {} {
	global HTMLmodeVars htmlDisabledItems htmlDisabledExtensions htmlDisabledDeprecated
	global htmlHideDeprecated htmlHideExtensions htmlHideFrames
	set htmlDisabledItems ""
	if {$htmlHideDeprecated || $HTMLmodeVars(hideDeprecated)} {
		set htmlDisabledItems $htmlDisabledDeprecated
	} elseif {$htmlHideExtensions || $HTMLmodeVars(hideExtensions)} {
		set htmlDisabledItems $htmlDisabledExtensions
	}
	if {$htmlHideDeprecated} {
		lappend htmlDisabledItems "Frames/Frameset" "Frames/Frame" "Frames/Inline Frame" "Frames/No Frames"
	} elseif {$htmlHideFrames} {
		lappend htmlDisabledItems "Frames/Frameset" "Frames/Frame"
	}
}

set htmlDisabledExtensions [list "Blocks and Dividers/Multi Column" \
  "Blocks and Dividers/Spacing" "Blocks and Dividers/No Line Break" "Blocks and Dividers/Word Break" \
  "Styles/Marquee" "Styles/Blinking" "Links/Sound" "${htmlMenu}/Plug-ins" \
  "Forms/Key Generator" "Java and JavaScript/Server" "${htmlMenu}/Layers"]

set htmlDisabledDeprecated $htmlDisabledExtensions
lappend htmlDisabledDeprecated "Java and JavaScript/Applet" "Styles/Font" "Styles/Basefont" \
  "Blocks and Dividers/Center" "Lists/Directory" "Lists/Menu" "Other/Isindex" \
  "Styles/Strike out" "Styles/Underlined"
htmlSetDis
